<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Fund History'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
     <div class="container-fluid px-3 user-service-list">



        <div class="row justify-content-between mx-lg-5">
            <div class="col-md-12">

                <ol class="breadcrumb center-items">
                    <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li class="active"><?php echo app('translator')->get('Fund History'); ?></li>
                </ol>

                <div class="card my-3">
                    <div class="card-body">

                        <form action="<?php echo e(route('user.fund-history.search')); ?>" method="get">
                            <div class="row justify-content-between align-items-center">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="text" name="name" value="<?php echo e(@request()->name); ?>" class="form-control"
                                               placeholder="<?php echo app('translator')->get('Type Here'); ?>">
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <select name="status" class="form-control">
                                            <option value=""><?php echo app('translator')->get('All Payment'); ?></option>
                                            <option value="1"
                                                    <?php if(@request()->status == '1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Complete Payment'); ?></option>
                                            <option value="2"
                                                    <?php if(@request()->status == '2'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Pending Payment'); ?></option>
                                            <option value="3"
                                                    <?php if(@request()->status == '3'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Cancel Payment'); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="date" class="form-control" name="date_time" id="datepicker"/>
                                    </div>
                                </div>


                                <div class="col-md-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn waves-effect waves-light w-100 btn-primary"><i
                                                class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="row my-3 justify-content-between mx-lg-5">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body ">

                            <div class="table-responsive">
                            <table class="table table-striped " id="service-table">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Transaction ID'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Gateway'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Charge'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Time'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $funds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>

                                        <td data-label="#<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e($data->transaction); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Gateway'); ?>"><?php echo app('translator')->get(optional($data->gateway)->name); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                            <strong><?php echo e(getAmount($data->amount)); ?> <?php echo app('translator')->get($basic->currency); ?></strong>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Charge'); ?>">
                                            <strong><?php echo e(getAmount($data->charge)); ?> <?php echo app('translator')->get($basic->currency); ?></strong>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                            <?php if($data->status == 1): ?>
                                                <span class="badge badge-success badge-pill"><?php echo app('translator')->get('Complete'); ?></span>
                                            <?php elseif($data->status == 2): ?>
                                                <span class="badge badge-warning badge-pill"><?php echo app('translator')->get('Pending'); ?></span>
                                            <?php elseif($data->status == 3): ?>
                                                <span class="badge badge-danger badge-pill"><?php echo app('translator')->get('Cancel'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Time'); ?>">
                                            <?php echo e(dateTime($data->created_at, 'd M Y h:i A')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            </div>
                            <?php echo e($funds->appends($_GET)->links()); ?>



                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/pages/transaction/fundHistory.blade.php ENDPATH**/ ?>