<?php $__env->startSection('title','Services'); ?>
<?php $__env->startSection('content'); ?>

    <section class=" service-list">
        <div class="container-fluid px-3 user-service-list">

            <div class="row my-3 justify-content-between mx-lg-5">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">

                            <form action="<?php echo e(route('service.search')); ?>" method="get">
                                <div class="row justify-content-center">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <input type="text" name="service" value="<?php echo e(@request()->service); ?>"
                                                   class="form-control"
                                                   placeholder="<?php echo app('translator')->get('Search for Services'); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <select name="category" id="category" class="form-control statusfield">
                                                <option value=""><?php echo app('translator')->get('All Category'); ?></option>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        value="<?php echo e($category->id); ?>" <?php echo e(($category->id == @request()->category) ? 'selected' : ''); ?>><?php echo app('translator')->get($category->category_title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>




                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary btn-padding w-100"><i
                                                    class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if( 0 < count($category->service)): ?>
                    <div class="row my-3 justify-content-between mx-lg-5">
                        <div class="col-md-12">
                            <div class="card ">
                                <div class="card-body">
                                    <h4 class="card-title mb-4"><?php echo e($category->category_title); ?>

                                        <a class="show-hide-icon float-right" data-toggle="collapse"
                                           href="#col-<?php echo e($category->id); ?>"
                                           aria-expanded="true" aria-controls="col-<?php echo e($category->id); ?>">
                                            <i class="fas fa-chevron-down"></i>
                                        </a>
                                    </h4>


                                    <div class="table-responsive collapse show" id="col-<?php echo e($category->id); ?>">
                                        <table
                                            class="categories-show-table table  table-striped text-dark">
                                            <thead>
                                            <tr>
                                                <th scope="col" class="text-center"><?php echo app('translator')->get('ID'); ?></th>
                                                <th scope="col" class="text-center"><?php echo app('translator')->get('Name'); ?></th>
                                                <th scope="col"
                                                    class="text-center"><?php echo app('translator')->get('Rate Per 1K'); ?></th>
                                                <th scope="col" class="text-center"><?php echo app('translator')->get('Min'); ?></th>
                                                <th scope="col" class="text-center"><?php echo app('translator')->get('Max'); ?></th>
                                                <th scope="col" class="text-center"><?php echo app('translator')->get('Description'); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $category->service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td data-label="<?php echo app('translator')->get('ID'); ?>" class="text-right text-md-center"><?php echo e($service->id); ?></td>
                                                    <td data-label="<?php echo app('translator')->get('Name'); ?>" class="text-right text-md-left">
                                                        <?php echo app('translator')->get($service->service_title); ?>
                                                    </td>
                                                    <td data-label="<?php echo app('translator')->get('Rate Per 1k'); ?>" class="text-right text-md-center">
                                                        <?php echo e(($service->user_rate) ?? $service->price); ?><?php echo e(config('basic.currency')); ?>

                                                    </td>
                                                    <td data-label="<?php echo app('translator')->get('Min'); ?>" class="text-right text-md-center">
                                                        <?php echo app('translator')->get($service->min_amount); ?>
                                                    </td>
                                                    <td data-label="<?php echo app('translator')->get('Max'); ?>" class="text-right text-md-center">
                                                         <?php echo app('translator')->get($service->max_amount); ?>
                                                    </td>

                                                    <td  data-label="<?php echo app('translator')->get('Description'); ?>" class="text-right text-md-center">
                                                        <button type="button"
                                                                class="btn details bg-transparent btn-default btn-sm text-dark"
                                                                data-toggle="modal"
                                                                data-target="#description"
                                                                data-id="<?php echo e($service->id); ?>"
                                                                data-servicetitle="<?php echo e($service->service_title); ?>"
                                                                data-description="<?php echo e($service->description); ?>">
                                                            <i class="fa fa-eye"></i> <?php echo app('translator')->get('More'); ?></button>
                                                    </td>
                                                </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </section>


    <div class="modal fade" id="description" tabindex="-1" role="dialog" aria-labelledby="description"
         aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header ">
                    <h4 class="modal-title" id="title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                </div>

                <!-- Modal body -->
                <div class="modal-body" id="servicedescription">

                </div>
                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-secondary btn-padding close"
                            data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="" type="submit" class="btn btn-sm btn-primary btn-padding order-now"><?php echo app('translator')->get('Order Now'); ?></a>
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .user-service-list .card-body thead th {
            background-color: #C1C7D0;
            border-color: #C1C7D0;
            color: #000;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        $(document).on('click', '.details', function () {
            var title = $(this).data('servicetitle');
            var id = $(this).data('id');

            var orderRoute = "<?php echo e(route('user.order.create')); ?>" + '?serviceId=' + id;
            $('.order-now').attr('href', orderRoute);

            var description = $(this).data('description');
            $('#title').text(title);
            $('#servicedescription').text(description);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/themes/minimal/services/show-service.blade.php ENDPATH**/ ?>