<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Transaction'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
     <div class="container-fluid px-3 user-service-list">

         <div class="row justify-content-between mx-lg-5">
             <div class="col-md-12">

                 <ol class="breadcrumb center-items">
                     <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                     <li class="active"><?php echo app('translator')->get('Transaction'); ?></li>
                 </ol>

                <div class="card my-3">
                    <div class="card-body">
                        <form action="<?php echo e(route('user.transaction.search')); ?>" method="get">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="text" name="transaction_id" value="<?php echo e(@request()->transaction_id); ?>" class="form-control get-trx-id"
                                               placeholder="<?php echo app('translator')->get('Search for Transaction ID'); ?>">
                                    </div>
                                </div>


                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="text" name="remark" value="<?php echo e(@request()->remark); ?>" class="form-control get-service"
                                               placeholder="<?php echo app('translator')->get('Remark'); ?>">
                                    </div>
                                </div>



                                <div class="col-md-3">
                                    <div class="form-group">
                                        <input type="date" class="form-control" name="datetrx" id="datepicker"/>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn waves-effect waves-light w-100 btn-primary"><i class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
             </div>
         </div>


        <div class="row my-3 justify-content-between mx-lg-5">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body ">

                            <div class="table-responsive">
                            <table class="table  table-striped " id="service-table">
                                <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('SL No.'); ?></th>
                                    <th ><?php echo app('translator')->get('Transaction ID'); ?></th>
                                    <th ><?php echo app('translator')->get('Amount'); ?></th>
                                    <th ><?php echo app('translator')->get('Remarks'); ?></th>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('SL No.'); ?>"><?php echo e(loopIndex($transactions) + $loop->index); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo app('translator')->get($transaction->trx_id); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <span
                                            class="font-weight-bold text-<?php echo e(($transaction->trx_type == "+") ? 'success': 'danger'); ?>"><?php echo e(($transaction->trx_type == "+") ? '+': '-'); ?><?php echo e(getAmount($transaction->amount, config('basic.fraction_number')). ' ' . trans(config('basic.currency'))); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Remarks'); ?>"> <?php echo app('translator')->get($transaction->remarks); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Time'); ?>">
                                            <?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            </div>
                            <?php echo e($transactions->appends($_GET)->links()); ?>



                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra-script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/pages/transaction/index.blade.php ENDPATH**/ ?>