<!DOCTYPE html >
<!--[if lt IE 7 ]><html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >
<!--<![endif]-->
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!--[if IE]>
    <meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'/>
    <![endif]-->
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700;800&family=Poppins:wght@500;600;700&display=swap">
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/jquery-ui.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/bootstrap.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/all.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/icofont.min.css')); ?>"/>
    <?php echo $__env->yieldPushContent('extra-style'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/animate.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/owl.carousel.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/owl.theme.default.min.css')); ?>"/>

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/color.php')); ?>?primaryColor=<?php echo e(config('color.primaryColor')); ?>&subheading=<?php echo e(config('color.subheading')); ?>&bggrdleft=<?php echo e(config('color.bggrdleft')); ?>&bggrdright=<?php echo e(config('color.bggrdright')); ?>&bggrdleft2=<?php echo e(config('color.bggrdleft2')); ?>&btngrdleft=<?php echo e(config('color.btngrdleft')); ?>&copyrights=<?php echo e(config('color.copyrights')); ?>">

    <?php echo $__env->yieldPushContent('style'); ?>

    <script src="<?php echo e(asset('assets/global/js/modernizr.custom.js')); ?>"></script>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body>
<!-- HERO -->
<header id="hero">
    <nav id="navbar">
        <div class="container-fluid px-md-5">
            <div class="navbar navbar-expand-lg mx-lg-5">

                <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>" alt="Logo">
                </a>

                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#smmnavbar">
                    <div class="menu-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                </button>
                <div class="collapse navbar-collapse" id="smmnavbar">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('home')); ?>" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('about')); ?>" href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About Us'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('services')); ?>" href="<?php echo e(route('services')); ?>"><?php echo app('translator')->get('Services'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('blog')); ?>" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('contact')); ?>" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                    </ul>

                    <ul class="navbar-nav nav-registration">
                        <?php if(auth()->guard()->guest()): ?>
                            <li class="nav-item mr-5">
                                <a class="<?php echo e(menuActive('login')); ?> nav-link"
                                   href="<?php echo e(route('login')); ?>"><span><?php echo app('translator')->get('Login'); ?></span></a>
                            </li>
                            <li class="nav-item">
                                <a class="<?php echo e(menuActive('register')); ?> nav-link active"
                                   href="<?php echo e(route('register')); ?>"><span><?php echo app('translator')->get('Sign up'); ?></span></a>
                            </li>
                        <?php endif; ?>
                        <?php if(auth()->guard()->check()): ?>
                            <li class="nav-item mr-5">
                                <a class="<?php echo e(menuActive('user.home')); ?> nav-link"
                                   href="<?php echo e(route('user.home')); ?>"><span><?php echo app('translator')->get('Dashboard'); ?></span></a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"><span><?php echo app('translator')->get('Logout'); ?></span></a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </nav>


    <?php if(\Request::routeIs('home')): ?>
        <?php echo $__env->yieldPushContent('banner'); ?>
    <?php else: ?>
        <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</header>
<!-- /HERO -->

<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->yieldPushContent('extra-content'); ?>


<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset('assets/global/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/jquery-ui.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/popper-1.12.9.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/fontawesome.min.js')); ?>"></script>
<?php echo $__env->yieldPushContent('extra-js'); ?>
<script src="<?php echo e(asset('assets/global/js/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/notiflix-aio-2.7.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/multi-animated-counter.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/script.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script'); ?>
<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.Success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.Failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.Warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>


</body>
</html>
<?php /**PATH D:\server\htdocs\codecanyon-exoVhLVV-smm-matrix-social-media-marketing-tool\project\resources\views/themes/minimal/layouts/app.blade.php ENDPATH**/ ?>