<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Notice List'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <div class="card card-primary m-0 m-md-4 my-4 m-md-0 shadow">

        <div class="card-body">

            <h3 class="card-title">
                <a class="btn btn-primary btn-sm float-right mb-3"
                   href="<?php echo e(route('admin.notice.create')); ?>"><i
                        class="fa fa-plus " aria-hidden="true"></i> <?php echo app('translator')->get('Add New'); ?></a>
            </h3>
            <div class="table-responsive">
                    <table class=" table table-hover table-striped table-bordered">
                        <thead class="thead-primary">
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('No.'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Title'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Highlight text'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $notices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('No.'); ?>"><?php echo app('translator')->get($loop->iteration); ?></td>
                                <td data-label="<?php echo app('translator')->get('Title'); ?>"><?php echo app('translator')->get($notice->title); ?> </td>
                                <td data-label="<?php echo app('translator')->get('Highlight text'); ?>"><span class="badge badge-info"><?php echo app('translator')->get($notice->highlight_text); ?></span> </td>

                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <span class="badge badge-pill <?php echo e($notice->status == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e($notice->status == 0 ? 'Inactive' : 'Active'); ?></span>
                                </td>

                                <td>
                                    <div class="dropdown show">
                                        <a class="dropdown-toggle" href="#" id="dropdownMenuLink" data-toggle="dropdown"
                                           aria-haspopup="true" aria-expanded="false">
                                            <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                            <a class="dropdown-item"
                                               href="<?php echo e(route('admin.notice.edit',[$notice->id])); ?>">
                                                <i class="fa fa-edit text-warning pr-2"
                                                   aria-hidden="true"></i> <?php echo app('translator')->get('Edit'); ?></a>
                                                <a href="javascript:void(0)"
                                                   class="dropdown-item deleteBtn"
                                                   data-toggle="modal"
                                                   data-toggle="modal" data-target="#top-modal"
                                                   data-route="<?php echo e(route('admin.notice.delete',[$notice->id])); ?>">
                                                    <i class="fa fa-trash text-danger"></i>
                                                    <?php echo app('translator')->get('Delete'); ?>
                                                </a>



                                        </div>
                                    </div>





                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
            </div>
            <?php echo e($notices->links()); ?>

        </div>
    </div>



    <!-- Top modal content -->
    <div id="top-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="topModalLabel"><?php echo app('translator')->get('Delete Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <strong><?php echo app('translator')->get('Are you sure to delete this?'); ?></strong>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light"
                            data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <form action="" class="form-inline deleteForm" method="post">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('delete'); ?>
                    <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Yes'); ?></button>
                    </form>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
<?php $__env->stopSection(); ?>



<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            "use strict";
            $('.deleteBtn').on('click', function () {
                let route = $(this).data('route');
                $('.deleteForm').attr('action', route);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\codecanyon-exoVhLVV-smm-matrix-social-media-marketing-tool\project\resources\views/admin/pages/notice/show.blade.php ENDPATH**/ ?>