<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get($page_title); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


    <div class="container-fluid px-3 user-service-list">

        <div class="row my-3 justify-content-between mx-lg-5">

            <div class="col-sm-12">
                <ol class="breadcrumb center-items">
                    <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li class="active"><?php echo app('translator')->get($page_title); ?></li>
                </ol>

                <div class="card my-3">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="categories-show-table table table-hover table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Subject'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Last Reply'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Subject'); ?>">
                                            <span class="font-weight-bold"> [<?php echo e(trans('Ticket#').$ticket->ticket); ?>] <?php echo e($ticket->subject); ?> </span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                            <?php if($ticket->status == 0): ?>
                                                <span class="badge badge-pill badge-success"><?php echo app('translator')->get('Open'); ?></span>
                                            <?php elseif($ticket->status == 1): ?>
                                                <span class="badge badge-pill badge-primary"><?php echo app('translator')->get('Answered'); ?></span>
                                            <?php elseif($ticket->status == 2): ?>
                                                <span class="badge badge-pill badge-warning"><?php echo app('translator')->get('Replied'); ?></span>
                                            <?php elseif($ticket->status == 3): ?>
                                                <span class="badge badge-pill badge-dark"><?php echo app('translator')->get('Closed'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Last Reply'); ?>">
                                            <?php echo e(diffForHumans($ticket->last_reply)); ?>

                                        </td>

                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <a href="<?php echo e(route('user.ticket.view', $ticket->ticket)); ?>"
                                               class="btn btn-sm btn-outline-info"
                                               data-toggle="tooltip" title="" data-original-title="Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%">
                                            <p class="text-dark"><?php echo app('translator')->get('No Data Found'); ?></p>
                                        </td>
                                    </tr>

                                <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($tickets->appends($_GET)->links()); ?>

                        </div>


                    </div>
                </div>

            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\server\htdocs\smmFinal\project\resources\views/user/pages/support/index.blade.php ENDPATH**/ ?>