
<!-- FOOTER -->
<footer id="footer">
    <figure class="footer-shape">
        <svg class="shape-fill" enable-background="new 0 0 1504 110" viewBox="0 0 1504 110"
             xmlns="http://www.w3.org/2000/svg">
            <path
                d="m877.8 85c139.5 24.4 348 33.5 632.2-48.2-.2 32.5-.3 65-.5 97.4-505.9 0-1011.6 0-1517.5 0 0-33.3 0-66.7 0-100.1 54.2-11.4 129.5-23.9 220-28.2 91-4.3 173.6 1 307.4 18.6 183.2 24.2 295.2 49.4 358.4 60.5z"></path>
        </svg>
    </figure>

    <div class="container">
        <div class="row pt-50">
            <?php if( isset($templates['contact-us'][0])  && $contactUs = $templates['contact-us'][0]): ?>
            <div class="col-lg-6">
                <div class="row footer-address">
                    <div class="col-lg-6">
                        <ul class="icofont-ul">
                            <li class="mb-15"><i class="icofont-iphone"></i> <span><?php echo app('translator')->get(@$contactUs->description->phone); ?></span></li>
                            <li><i class="icofont-envelope-open"></i> <span><?php echo app('translator')->get(@$contactUs->description->email); ?></span></li>
                        </ul>
                    </div>
                    <div class="col-lg-6">
                        <div class="media">
                            <div class="media-icon">
                                <i class="icofont-google-map"></i>
                            </div>
                            <div class="media-body">
                                <p class="media-text"><?php echo app('translator')->get(@$contactUs->description->address); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="col-lg-6">
                <div class="subscribe" id="subscribe">
                    <form class="subscribe-form" action="<?php echo e(route('subscribe')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input class="form-control" name="email" type="email" placeholder="<?php echo e(trans('Email Address')); ?>">

                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <button class="btn" type="submit"><?php echo e(trans('Subscribe Now')); ?></button>
                    </form>
                </div>
            </div>
        </div>
        <hr>

        <div class="row responsive-footer">
            <div class="col-md-6 col-lg-3">
                <div class="footer-brand">
                    <img src="<?php echo e(getFile(config('location.logoIcon.path').'footer-logo.png')); ?>" alt="Image Missing">
                    <p>
                        <?php echo app('translator')->get(@$contactUs->description->footer_short_details); ?>
                    </p>
                </div>

                <?php if(isset($contentDetails['social'])): ?>
                <div class="footer-social">
                    <?php $__currentLoopData = $contentDetails['social']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a class="social-icon" target="_blank" href="<?php echo e(@$data->content->contentMedia->description->link); ?>" title="<?php echo e($data->description->name); ?>"><i class="<?php echo e(@$data->content->contentMedia->description->icon); ?>"></i></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php endif; ?>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="footer-links">
                    <h5><?php echo e(trans('Quick Links')); ?></h5>
                    <ul class="nav flex-column mt-40">
                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                        </li>
                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About Us'); ?></a>
                        </li>
                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </li>

                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('faq')); ?>"><?php echo app('translator')->get('FAQ'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="footer-links">
                    <h5><?php echo e(trans('Support')); ?></h5>
                    <ul class="nav flex-column mt-40">

                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('apiDocs')); ?>"><?php echo app('translator')->get('API DOCS'); ?></a>
                        </li>
                        <?php if(isset($contentDetails['support'])): ?>
                        <?php $__currentLoopData = $contentDetails['support']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item mb-10">
                                <a class="nav-link" href="<?php echo e(route('getLink', [slug($data->description->title), $data->content_id])); ?>"><?php echo app('translator')->get($data->description->title); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                    </ul>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="footer-links">
                    <h5><?php echo app('translator')->get('Language'); ?></h5>
                    <ul class="nav flex-column mt-40">
                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item mb-10">
                            <a class="nav-link" href="<?php echo e(route('language',[$language->short_name])); ?>"><?php echo e($language->name); ?></a>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="copy-rights">
        <div class="container">
            <p><?php echo e(trans('Copyright')); ?> &copy; <?php echo e(date('Y')); ?> <?php echo e(trans(config('basic.site_title'))); ?>. <?php echo e(trans('All Rights Reserved')); ?></p>
        </div>
    </div>
</footer>
<!-- /FOOTER -->
<?php /**PATH D:\server\htdocs\codecanyon-exoVhLVV-smm-matrix-social-media-marketing-tool\project\resources\views/themes/minimal/partials/footer.blade.php ENDPATH**/ ?>